<?php

add_filter('post.add.customer', 'channexpci_tokenize', 5, 1);
add_filter('tokenize_request', 'channexpci_filter_request', 5,1);

function channexpci_tokenize ($data)
{
    $filtered_data = $data;

    unset($filtered_data['customer_data']);

    $api_key = $_SERVER['CHANNEX_PCI_API_KEY'];
    $api_url = 'https://pci.channex.io/api/v1/cards?api_key=' . $api_key;
    $method_type = 'POST';

    $card_type = get_credit_card_type($filtered_data['card']['card_number']);

    if ($card_type) {
        $filtered_data['card']['card_type'] = $card_type;
    }

    $headers = array(
        "Content-Type: application/json",
    );

    $response = call_api($api_url, $filtered_data, $headers, $method_type);

    $response = json_decode($response, true);

    $data['tokenization_response'] = $response;

    return $data;
}


function channexpci_filter_request($data){

    $api_key = $_SERVER['CHANNEX_PCI_API_KEY'];

    $api_url = 'https://pci.channex.io/api/v1/cards/' . $data['card_token'] . '/send?api_key=' . $api_key . '&method=post&url=' . $data['url'];
    $data['api_url'] = $api_url;
    return $data;
    
}

if (!function_exists('get_credit_card_type')) {
    function get_credit_card_type($cardNumber)
    {
        // Remove non-digits from the number
        $cardNumber = preg_replace('/\D/', '', $cardNumber);

        // Validate the length
        $len = strlen($cardNumber);
        if ($len < 15 || $len > 16) {
            throw new Exception("Invalid credit card number. Length does not match");
        } else {
            switch ($cardNumber) {
                case (preg_match('/^4/', $cardNumber) >= 1):
                    return 'Visa';
                case (preg_match('/^5[1-5]/', $cardNumber) >= 1):
                    return 'Master';
                case (preg_match('/^3[47]/', $cardNumber) >= 1):
                    return 'Amex';
                case (preg_match('/^3(?:0[0-5]|[68])/', $cardNumber) >= 1):
                    return 'Diners';
                case (preg_match('/^6(?:011|5)/', $cardNumber) >= 1):
                    return 'Discover';
                case (preg_match('/^(?:2131|1800|35\d{3})/', $cardNumber) >= 1):
                    return 'JCB';
                default:
                    throw new Exception("Could not determine the credit card type.");
                    break;
            }
        }
    }

}

if (!function_exists('call_api')) {
    function call_api($api_url, $data, $headers, $method_type = 'POST')
    {

        $url = $api_url;

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        if ($method_type == 'GET') {

        } else {
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        }

        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($curl);

        curl_close($curl);

        return $response;
    }
}
